import math
import numpy as np
import csv
import os
import pandas as pd
import scipy as sp
from scipy import interpolate
from scipy.interpolate import interp1d
from numpy import genfromtxt


def scan_range(lambda_mean, res):
    items = os.listdir(".")
    for names in items:
        if names.endswith("parameters_int.txt"):
            filename = names

    ref = pd.read_csv(filename, sep="\t", header=None)
    first_row = (ref.iloc[0])
    ref1 = first_row.to_numpy(dtype='float64')

    low = ref1[0]
    high = ref1[-1]

    alpha = np.radians(10)
    min_e = 100.0
    min_o = 100.0
    lambda_mean = lambda_mean / 1000

    extra=genfromtxt('Tamosauskas-e.csv', delimiter=',')
    ordinary=genfromtxt('Tamosauskas-o.csv', delimiter=',')

    wave_extra=extra[:,0]
    n_extra=extra[:,1]
    f1=interp1d(wave_extra, n_extra, kind="linear")
    n_e=f1(lambda_mean)

    wave_ordinary=ordinary[:,0]
    n_ordinary=ordinary[:,1]
    f2=interp1d(wave_ordinary, n_ordinary, kind="linear")
    n_o = f2(lambda_mean)


tic=time.clock()
e18 = np.genfromtxt('Interf.txt', delimiter = '\t')
toc = time.clock()
tictoc = toc - tic
print(tictoc)
